<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->user_id === (int) $id;
});

// SUPERADMIN NOTIFICATIONS CHANNEL
Broadcast::channel('superadmin.notifications', function ($user) {
    // Agar user logged in nahi → reject
    if (!$user) return false;

    // Sirf SuperAdmin (role_id = 1) ko allow karo
    return $user->role_id === 1 || $user->hasRole('superadmin') || $user->is_superadmin == 1;
});
