<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\ProvinceController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ParentProfileController;
use App\Http\Controllers\OccupationCategoryController;
use App\Http\Controllers\BabysitterProfileController;
use App\Http\Controllers\CommissionRateController;
use App\Http\Controllers\BookingTypeController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\UserLanguageController;
use App\Http\Controllers\LanguageTranslationController;
use App\Http\Controllers\CareRecipientController;
use App\Http\Controllers\DirectBookingRequestController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PayoutController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\BabysitterSkillController;
use App\Http\Controllers\ContentPageController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReportTemplateController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\RefundController;
use App\Http\Controllers\CommissionEarningController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\BabysitterDashboardController;
use App\Http\Controllers\NotificationController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public Authentication Routes
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::post('forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('reset-password', [AuthController::class, 'resetPassword']);
Route::post('verify-reset-token', [AuthController::class, 'verifyResetToken']); // Add this line

// ✅ SUPER ADMIN EMERGENCY ROUTES (Public but protected in controller)
Route::get('check-super-admin', [AuthController::class, 'checkSuperAdmin']);
Route::post('register-super-admin', [AuthController::class, 'registerSuperAdmin']);

Route::post('payments/razorpay/verify', [PaymentController::class, 'verifyRazorpayPayment'])
    ->withoutMiddleware(['csrf']);

Route::post('payments/razorpay/webhook', [PaymentController::class, 'razorpayWebhook'])
    ->withoutMiddleware(['csrf']);

// Public Data Routes (for dropdowns, etc.)
Route::get('countries', [CountryController::class, 'index']);
Route::get('countries/dropdown', [CountryController::class, 'getAllForDropdown']);
Route::get('countries/code/{code}', [CountryController::class, 'getByCode']);
Route::get('countries/{id}', [CountryController::class, 'show']);

Route::get('provinces', [ProvinceController::class, 'index']);
Route::get('provinces/dropdown', [ProvinceController::class, 'dropdownList']); // Dropdown list
Route::get('provinces/country/{countryId}', [ProvinceController::class, 'getByCountry']);
Route::get('provinces/by-code', [ProvinceController::class, 'getByCode']);
Route::get('provinces/{id}', [ProvinceController::class, 'show']);


Route::get('cities', [CityController::class, 'index']);
Route::get('cities/all', [CityController::class, 'getAll']);
Route::get('cities/province/{provinceId}', [CityController::class, 'getByProvince']);
Route::get('cities/search', [CityController::class, 'search']);
Route::get('cities/{id}', [CityController::class, 'show']);

Route::get('addresses', [AddressController::class, 'index']);

// Language Routes
Route::get('languages', [LanguageController::class, 'index']);
Route::get('languages/all', [LanguageController::class, 'getAllLanguages']);
Route::get('languages/active', [LanguageController::class, 'getActiveLanguages']);
Route::get('languages/code/{code}', [LanguageController::class, 'getByCode']);
Route::get('languages/{id}', [LanguageController::class, 'show']);

// Public Language Translations
Route::get('language-translations', [LanguageTranslationController::class, 'index']);
Route::get('language-translations/all', [LanguageTranslationController::class, 'getAll']);
Route::get('language-translations/language/{languageCode}', [LanguageTranslationController::class, 'getByLanguage']);
Route::get('language-translations/language/{languageCode}/key/{key}', [LanguageTranslationController::class, 'getByKey']);
Route::get('language-translations/language/{languageCode}/section/{section}', [LanguageTranslationController::class, 'getBySection']);
Route::get('language-translations/sections', [LanguageTranslationController::class, 'getSections']);
Route::get('language-translations/{id}', [LanguageTranslationController::class, 'show']);

// Public Occupation Categories
Route::get('/occupation-categories/all', [OccupationCategoryController::class, 'getAll']);
Route::get('occupation-categories', [OccupationCategoryController::class, 'index']);
Route::get('occupation-categories/{id}', [OccupationCategoryController::class, 'show']);
Route::get('occupation-categories/type/{type}', [OccupationCategoryController::class, 'getByType']);
Route::get('occupation-categories/active/list', [OccupationCategoryController::class, 'getActiveCategories']);

// Public Commission Rates (for calculations)
Route::get('commission-rates/current', [CommissionRateController::class, 'getCurrentRates']);
Route::get('commission-rates/calculate', [CommissionRateController::class, 'getRateFor']);
Route::get('commission-rates', [CommissionRateController::class, 'index']);
Route::get('commission-rates/{id}', [CommissionRateController::class, 'show']);

// Public Booking Types
Route::get('booking-types', [BookingTypeController::class, 'index']);
Route::get('booking-types/active', [BookingTypeController::class, 'getActiveTypes']);
Route::get('booking-types/by-duration', [BookingTypeController::class, 'getByDuration']);
Route::get('booking-types/{id}', [BookingTypeController::class, 'show']);
Route::get('booking-types/{id}/validate-duration', [BookingTypeController::class, 'validateDuration']);

// Public Addresses (limited access)
Route::get('addresses/search/location', [AddressController::class, 'searchByLocation']);

// Public User Languages (limited access)
Route::get('user-languages/proficiency-options', [UserLanguageController::class, 'getProficiencyOptions']);
Route::get('user-languages/language/{languageCode}', [UserLanguageController::class, 'getUsersByLanguage']);

// Public Babysitter Profiles (for searching)
Route::get('babysitter-profiles', [BabysitterProfileController::class, 'index']);
Route::get('babysitter-profiles/search', [BabysitterProfileController::class, 'search']);
Route::get('babysitter-profiles/{id}', [BabysitterProfileController::class, 'show']);


Route::get('parent-profile', [ParentProfileController::class, 'index']); // Get all profiles
Route::get('parent-profile/{id}', [ParentProfileController::class, 'show']); // Get profile by ID    // Get single profile
Route::get('parent-profiles/paginated', [ParentProfileController::class, 'paginated']);

// Public Reviews (limited access)
Route::get('reviews', [ReviewController::class, 'index']);
Route::get('reviews/{id}', [ReviewController::class, 'show']);

// Public Babysitter Skills (limited access)
Route::get('babysitter-skills', [BabysitterSkillController::class, 'index']); // Public access
Route::get('babysitter-skills/{id}', [BabysitterSkillController::class, 'show']); // Public access

// Public Content Pages Routes
Route::get('content-pages', [ContentPageController::class, 'index']);
Route::get('content-pages/slug/{slug}', [ContentPageController::class, 'getBySlug']);
Route::get('content-pages/type/{type}', [ContentPageController::class, 'getByType']);
Route::get('content-pages/{id}', [ContentPageController::class, 'show']);


// Direct Booking Requests Routes (moved inside auth middleware)

// Protected Routes (require authentication)
Route::middleware('auth:sanctum')->group(function () {
    // Authentication routes
    Route::post('logout', [AuthController::class, 'logout']);
    Route::post('refresh', [AuthController::class, 'refresh']);
    Route::get('me', [AuthController::class, 'me']);
    Route::post('change-password', [AuthController::class, 'changePassword']);

    // User Management Routes
    Route::apiResource('users', UserController::class);
    Route::get('users/profile/me', [UserController::class, 'getProfile']);
    Route::put('users/profile/me', [UserController::class, 'updateProfile']);
    Route::post('users/{user}/profile-picture', [UserController::class, 'updateProfilePicture']);
    Route::post('users/{user}/password', [UserController::class, 'updatePassword']);
    Route::delete('/profile/profile-picture', [UserController::class, 'deleteMyProfilePicture']);
    Route::delete('/users/{id}/profile-picture', [UserController::class, 'deleteProfilePicture']);

    Route::post('users/{user}/verify-email', [UserController::class, 'verifyEmail']);
    Route::post('users/{user}/verify-phone', [UserController::class, 'verifyPhone']);
    Route::post('users/{user}/activate', [UserController::class, 'activateUser']);
    Route::post('users/{user}/deactivate', [UserController::class, 'deactivateUser']);
    Route::get('users/role/{roleName}', [UserController::class, 'getByRole']);

    // Role Management Routes
    Route::apiResource('roles', RoleController::class);
    Route::get('roles/name/{name}', [RoleController::class, 'getByName']);

    // Address Management Routes
    Route::get('addresses', [AddressController::class, 'index']);
    Route::put('addresses/save', [AddressController::class, 'saveAddress']); // ✅ Single PUT for create/update
    Route::get('addresses/{id}', [AddressController::class, 'show']);
    Route::delete('addresses/{id}', [AddressController::class, 'destroy']);
    Route::get('/my-addresses', [AddressController::class, 'getMyAddresses']);
    Route::put('addresses/{id}/set-primary', [AddressController::class, 'setAsPrimary']);
    Route::get('users/{userId}/primary-address', [AddressController::class, 'getPrimaryAddress']);
    Route::get('users/{userId}/addresses', [AddressController::class, 'getUserAddresses']);

    // Language Management Routes (Admin operations)
    Route::post('languages', [LanguageController::class, 'store']);
    Route::put('languages/{id}', [LanguageController::class, 'update']);
    Route::delete('languages/{id}', [LanguageController::class, 'destroy']);

    // Language Translation Management Routes (Admin only)
    Route::post('language-translations', [LanguageTranslationController::class, 'store']);
    Route::put('language-translations/{id}', [LanguageTranslationController::class, 'update']);
    Route::delete('language-translations/{id}', [LanguageTranslationController::class, 'destroy']);
    Route::post('language-translations/bulk-update', [LanguageTranslationController::class, 'bulkUpdate']);

    // User Language Management Routes
    Route::get('user-languages', [UserLanguageController::class, 'index']);
    Route::put('user-languages/save', [UserLanguageController::class, 'saveLanguage']); // ✅ Single PUT for create/update
    Route::get('user-languages/{id}', [UserLanguageController::class, 'show']);
    Route::delete('user-languages/{id}', [UserLanguageController::class, 'destroy']);
    Route::get('user-languages/my-languages', [UserLanguageController::class, 'getMyLanguages']);
    Route::put('user-languages/{id}/set-primary', [UserLanguageController::class, 'setAsPrimary']);
    Route::put('user-languages/add-multiple', [UserLanguageController::class, 'addMultipleLanguages']);

    // Parent Profile Routes
    Route::post('parent-profile', [ParentProfileController::class, 'store']);  // Create/Update profile
    Route::put('parent-profile', [ParentProfileController::class, 'update']);  // Update profile
    Route::delete('parent-profile', [ParentProfileController::class, 'destroy']); // Delete profile

    // Babysitter Profile Management
    Route::post('babysitter-profiles', [BabysitterProfileController::class, 'store']);
    Route::put('babysitter-profiles/{id}', [BabysitterProfileController::class, 'update']);
    Route::delete('babysitter-profiles/{id}', [BabysitterProfileController::class, 'destroy']);
    Route::get('babysitter-profile/my-profile', [BabysitterProfileController::class, 'showCurrentUser']);
    Route::post('babysitter-profile/my-profile', [BabysitterProfileController::class, 'storeCurrentUser']);

    // In the auth middleware group:
    Route::get('babysitter/dashboard', [BabysitterDashboardController::class, 'getBabysitterDashboard']);
    Route::get('babysitter/dashboard/quick-stats', [BabysitterDashboardController::class, 'getQuickStats']);

    // Commission Rates Management (Admin only)
    Route::apiResource('commission-rates', CommissionRateController::class)->except(['index', 'show']);

    // Booking Types Management (Admin only)
    Route::apiResource('booking-types', BookingTypeController::class)->except(['index', 'show']);
    Route::post('booking-types', [BookingTypeController::class, 'store']);
    Route::put('booking-types/{id}', [BookingTypeController::class, 'update']);
    Route::delete('booking-types/{id}', [BookingTypeController::class, 'destroy']);

    // Occupation Categories Management (Admin only)
    Route::post('occupation-categories', [OccupationCategoryController::class, 'store']);
    Route::put('occupation-categories/{id}', [OccupationCategoryController::class, 'update']);
    Route::delete('occupation-categories/{id}', [OccupationCategoryController::class, 'destroy']);

    // Country, Province, City Management Routes (Admin only)
    Route::post('countries', [CountryController::class, 'store']);
    Route::put('countries/{id}', [CountryController::class, 'update']);
    Route::delete('countries/{id}', [CountryController::class, 'destroy']);

    Route::post('provinces', [ProvinceController::class, 'store']);
    Route::put('provinces/{id}', [ProvinceController::class, 'update']);
    Route::delete('provinces/{id}', [ProvinceController::class, 'destroy']);

    Route::post('cities', [CityController::class, 'store']);
    Route::put('cities/{id}', [CityController::class, 'update']);
    Route::delete('cities/{id}', [CityController::class, 'destroy']);

    // Care Recipients Routes (protected)
    Route::get('care-recipients', [CareRecipientController::class, 'index']);
    Route::get('care-recipients/{id}', [CareRecipientController::class, 'show']);
    Route::put('care-recipients', [CareRecipientController::class, 'createOrUpdate']); // Create or Update
    Route::delete('care-recipients/{id}', [CareRecipientController::class, 'destroy']);

    // Direct Booking Requests Routes (protected)
    Route::get('booking-requests', [DirectBookingRequestController::class, 'index']);
    Route::get('booking-requests/my-requests', [DirectBookingRequestController::class, 'getMyRequests']);
    Route::get('booking-requests/{id}', [DirectBookingRequestController::class, 'show']);
    Route::post('booking-requests', [DirectBookingRequestController::class, 'store']);
    Route::put('booking-requests/{id}', [DirectBookingRequestController::class, 'update']);
    Route::post('booking-requests/{id}/accept', [DirectBookingRequestController::class, 'accept']);
    Route::post('booking-requests/{id}/reject', [DirectBookingRequestController::class, 'reject']);
    Route::post('booking-requests/{id}/cancel', [DirectBookingRequestController::class, 'cancel']);

    // Add these to your routes
    Route::get('booking-requests/expiring', [DirectBookingRequestController::class, 'getExpiringRequests']);
    Route::post('booking-requests/{id}/force-expire', [DirectBookingRequestController::class, 'forceExpire']);

    // Add these routes:
    Route::get('bookings', [BookingController::class, 'index']);
    Route::get('bookings/my-bookings', [BookingController::class, 'getMyBookings']);
    Route::get('bookings/{id}', [BookingController::class, 'show']);
    Route::post('bookings', [BookingController::class, 'store']);
    Route::put('bookings/{id}/status', [BookingController::class, 'updateStatus']);
    Route::post('bookings/{id}/confirm', [BookingController::class, 'confirmBooking']);
    Route::post('bookings/{id}/start', [BookingController::class, 'startBooking']);
    Route::post('bookings/{id}/complete', [BookingController::class, 'completeBooking']);
    Route::get('superadmin/bookings', [BookingController::class, 'getAllBookingsForSuperAdmin']);
    Route::get('superadmin/bookings/{id}/view', [BookingController::class, 'getBookingViewForSuperAdmin']);

    // Add these routes in your auth:sanctum group

    // Super Admin Dashboard Routes
    Route::get('superadmin/dashboard', [DashboardController::class, 'getSuperAdminDashboard']);
    Route::get('superadmin/dashboard/quick-stats', [DashboardController::class, 'getQuickStats']);

    Route::post('bookings/{id}/force-complete', [BookingController::class, 'forceCompleteBooking']);
    // Payment API Routes (CSRF Protected except verify & webhook)
    Route::post('payments/razorpay/create-order', [PaymentController::class, 'createRazorpayOrder']);
    Route::get('payments/my-payments', [PaymentController::class, 'getMyPayments']);

    // Commission Earnings Routes (protected)
    Route::get('commission-earnings/breakdown/{bookingId}', [CommissionEarningController::class, 'getCommissionBreakdown']);
    Route::get('commission-earnings/booking/{bookingId}', [CommissionEarningController::class, 'getByBooking']);
    // Other commission earnings routes (agar needed हों)
    Route::get('commission-earnings', [CommissionEarningController::class, 'index']);
    Route::get('commission-earnings/{id}', [CommissionEarningController::class, 'show']);
    Route::post('commission-earnings', [CommissionEarningController::class, 'store']);
    Route::put('commission-earnings/{id}/mark-processed', [CommissionEarningController::class, 'markAsProcessed']);
    Route::put('commission-earnings/{id}/mark-paid-out', [CommissionEarningController::class, 'markAsPaidOut']);
    Route::post('commission-earnings/bulk-process', [CommissionEarningController::class, 'bulkProcess']);
    Route::get('commission-earnings/monthly-report', [CommissionEarningController::class, 'getMonthlyReport']);
    // ✅ NEW PAYMENT DATA ROUTES
    Route::get('payments', [PaymentController::class, 'getAllPayments']);
    Route::get('payments/statistics', [PaymentController::class, 'getPaymentStatistics']);
    Route::get('payments/summary', [PaymentController::class, 'getPaymentsSummary']);
    Route::get('payments/{id}', [PaymentController::class, 'getPaymentById']);
    Route::get('payments/booking/{bookingId}', [PaymentController::class, 'getPaymentsByBooking']);

    // Existing manual override routes
    Route::put('payments/{id}/mark-completed', [PaymentController::class, 'markAsCompleted']);
    Route::put('payments/{id}/mark-refunded', [PaymentController::class, 'markAsRefunded']);

    // // Refund Routes
    // Route::post('refunds/{paymentId}/process', [RefundController::class, 'processRefund']);
    // Route::get('refunds/{paymentId}/status', [RefundController::class, 'getRefundStatus']);

    // Payout Management Routes (protected)
    Route::apiResource('payouts', PayoutController::class);
    Route::get('payouts/my-payouts', [PayoutController::class, 'getMyPayouts']);
    Route::post('payouts/{id}/processing', [PayoutController::class, 'markAsProcessing']);
    Route::post('payouts/{id}/complete', [PayoutController::class, 'markAsCompleted']);
    Route::post('payouts/{id}/fail', [PayoutController::class, 'markAsFailed']);
    // Payout Routes
    Route::get('payouts/my-payouts', [PayoutController::class, 'getMyPayouts']);


    // Review Management Routes (protected)
    Route::apiResource('reviews', ReviewController::class)->except(['index', 'show']);
    Route::get('reviews/my-reviews', [ReviewController::class, 'getMyReviews']);
    Route::get('reviews/about-me', [ReviewController::class, 'getReviewsAboutMe']);
    Route::post('reviews/{id}/helpful', [ReviewController::class, 'markAsHelpful']);
    Route::post('reviews/{id}/report', [ReviewController::class, 'reportReview']);
    // Get reviews for a specific booking
    Route::get('bookings/{id}/reviews', [ReviewController::class, 'getReviewsByBooking']);
    // Check if user can review a booking
    Route::get('bookings/{id}/can-review', [ReviewController::class, 'checkCanReview']);
    // Get pending reviews (bookings that need review)
    Route::get('reviews/pending', [ReviewController::class, 'getPendingReviews']);
    // Get user rating statistics
    Route::get('users/{id}/rating-stats', [ReviewController::class, 'getUserRatingStats']);

    // Babysitter Skill Management Routes (protected)
    Route::put('babysitter-skills/save', [BabysitterSkillController::class, 'saveSkill']); // Auth - Create/Update
    Route::delete('babysitter-skills/{id}', [BabysitterSkillController::class, 'destroy']); // Auth - Delete skill
    Route::delete('babysitter-skills/{id}/certificate', [BabysitterSkillController::class, 'deleteCertificate']); // Auth - Delete certificate only

    // Report Management Routes
    Route::apiResource('reports', ReportController::class);
    Route::post('reports/generate/financial', [ReportController::class, 'generateFinancialReport']);
    Route::post('reports/generate/user', [ReportController::class, 'generateUserReport']);
    Route::post('reports/{id}/archive', [ReportController::class, 'archive']);
    Route::post('reports/{id}/unarchive', [ReportController::class, 'unarchive']);

    // Report Template Management Routes
    Route::apiResource('report-templates', ReportTemplateController::class);
    Route::post('report-templates/{id}/activate', [ReportTemplateController::class, 'activate']);
    Route::post('report-templates/{id}/deactivate', [ReportTemplateController::class, 'deactivate']);
    Route::post('report-templates/{id}/generate', [ReportTemplateController::class, 'generateReport']);

    // New Template Generation Routes
    Route::get('report-templates/predefined/list', [ReportTemplateController::class, 'getPredefinedTemplates']);
    Route::post('report-templates/predefined/create', [ReportTemplateController::class, 'createFromPredefined']);

    // Content Pages Management Routes (Protected - Admin only)
    Route::apiResource('content-pages', ContentPageController::class)->except(['index', 'show']);
    Route::post('content-pages/{id}/publish', [ContentPageController::class, 'publish']);
    Route::post('content-pages/{id}/unpublish', [ContentPageController::class, 'unpublish']);


    // Notification Routes
    Route::get('notifications', [NotificationController::class, 'index']);
    Route::get('notifications/unread-count', [NotificationController::class, 'getUnreadCount']);
    Route::get('notifications/stats', [NotificationController::class, 'getStats']);
    Route::put('notifications/{id}/read', [NotificationController::class, 'markAsRead']);
    Route::put('notifications/{id}/unread', [NotificationController::class, 'markAsUnread']);
    Route::put('notifications/mark-all-read', [NotificationController::class, 'markAllAsRead']);
    Route::delete('notifications/{id}', [NotificationController::class, 'destroy']);
    Route::delete('notifications/clear-all', [NotificationController::class, 'clearAll']);
});



// Fallback route for undefined API endpoints
Route::fallback(function () {
    return response()->json([
        'success' => false,
        'message' => 'API endpoint not found'
    ], 404);
});
