<!DOCTYPE html>
<html>
<head>
    <title>Real-Time Notifications</title>
    <script src="https://js.pusher.com/8.2/pusher.min.js"></script>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <style>
        body { font-family: Arial; padding: 20px; background: #f0f0f0; }
        .box { background: white; padding: 20px; border-radius: 10px; margin: 10px 0; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .success { color: green; font-weight: bold; }
        .error { color: red; font-weight: bold; }
        .loading { color: blue; }
        .notif {
            background: #d4edda;
            padding: 15px;
            margin: 10px 0;
            border-left: 5px solid #28a745;
            border-radius: 5px;
            animation: slideIn 0.5s ease-in;
        }
        @keyframes slideIn { from { transform: translateX(-100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }
    </style>
</head>
<body>

<div class="box">
    <h1>🔔 Real-Time Registration Notifications</h1>
    <button onclick="connectPusher()">Connect Pusher</button>
    <div id="status" class="loading">Click "Connect Pusher" to start</div>
</div>

<div class="box">
    <h2>👁️ Live Notifications</h2>
    <div id="notification-list">
        <div class="loading">🔔 Real-time notifications will appear here when users register via API</div>
    </div>
</div>

<script>
    let pusher = null;
    let channel = null;

    function connectPusher() {
        try {
            Pusher.logToConsole = true;
            document.getElementById('status').innerHTML = '<span class="loading">🔄 Connecting to Pusher...</span>';

            pusher = new Pusher('20b00b71ddfc1a2efd3a', {
                cluster: 'us3',
                forceTLS: true,
            });

            pusher.connection.bind('connected', () => {
                const socketId = pusher.connection.socket_id;
                document.getElementById('status').innerHTML = '<span class="success">✅ Pusher Connected! Socket: ' + socketId + '</span>';
                subscribeToChannel();
            });

            pusher.connection.bind('failed', (error) => {
                document.getElementById('status').innerHTML = '<span class="error">❌ Connection Failed</span>';
            });

        } catch (error) {
            document.getElementById('status').innerHTML = '<span class="error">❌ Error: ' + error.message + '</span>';
        }
    }

    function subscribeToChannel() {
        try {
            channel = pusher.subscribe('public-notifications');

            channel.bind('pusher:subscription_succeeded', () => {
                console.log('✅ Subscribed to public-notifications');
                document.getElementById('status').innerHTML += '<br><span class="success">✅ Subscribed to public-notifications</span>';
                document.getElementById('status').innerHTML += '<br><span class="success">🎉 Ready! Register users via Postman/API</span>';
            });

            // ✅ EVENT LISTENER - YEH REAL EVENT SUNEGA
            channel.bind('user.registered', function(data) {
                console.log('🎉 REAL-TIME NOTIFICATION RECEIVED:', data);
                showNotification(data);
            });

        } catch (error) {
            console.error('Subscribe error:', error);
        }
    }

    function showNotification(data) {
        console.log('🖥️ Showing notification for:', data.user_email);

        const list = document.getElementById('notification-list');

        if (list.innerHTML.includes('Real-time notifications will appear')) {
            list.innerHTML = '';
        }

        const notificationDiv = document.createElement('div');
        notificationDiv.className = 'notif';
        notificationDiv.innerHTML = `
            <div style="display: flex; align-items: flex-start; gap: 15px;">
                <div style="font-size: 32px;">${data.icon || '👤'}</div>
                <div style="flex: 1;">
                    <strong style="font-size: 18px; color: #155724;">🎉 New ${data.user_type} Registered!</strong>
                    <div style="margin-top: 10px; line-height: 1.6;">
                        <div>📧 <strong>Email:</strong> ${data.user_email}</div>
                        <div>👤 <strong>Name:</strong> ${data.user_name}</div>
                        <div>🆔 <strong>User ID:</strong> ${data.user_id}</div>
                        <div>🕒 <strong>Time:</strong> ${data.timestamp}</div>
                        <div style="margin-top: 8px; padding: 8px; background: #c3e6cb; border-radius: 4px;">
                            📝 "${data.message}"
                        </div>
                    </div>
                </div>
            </div>
        `;

        list.prepend(notificationDiv);
    }

    // Auto connect
    window.onload = connectPusher;
</script>
</body>
</html>
