<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sitly.ca</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="max-w-md w-full bg-white rounded-2xl shadow-sm p-8">
        <div class="text-center mb-8">
            <i class="fas fa-child text-4xl text-indigo-600 mb-4"></i>
            <h1 class="text-3xl font-bold text-gray-900">Sitly.ca</h1>
            <p class="text-gray-600 mt-2">Welcome back! Please sign in.</p>
        </div>

        <form id="loginForm" class="space-y-6">
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email Address</label>
                <input type="email" id="email" name="email" required
                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                       placeholder="Enter your email">
            </div>

            <div>
                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password</label>
                <input type="password" id="password" name="password" required
                       class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                       placeholder="Enter your password">
            </div>

            <button type="submit"
                    class="w-full bg-indigo-600 hover:bg-indigo-700 text-white py-3 px-4 rounded-lg transition duration-200 font-medium">
                Sign In
            </button>
        </form>

        <div class="mt-6 text-center">
            <p class="text-gray-600">Don't have an account?
                <a href="#" class="text-indigo-600 hover:text-indigo-500 font-medium">Sign up</a>
            </p>
        </div>

        <!-- Demo Login Button -->
        <div class="mt-6 pt-6 border-t border-gray-200">
            <button onclick="demoLogin()"
                    class="w-full bg-green-600 hover:bg-green-700 text-white py-3 px-4 rounded-lg transition duration-200 font-medium">
                Quick Demo Login
            </button>
            <p class="text-xs text-gray-500 text-center mt-2">Use this for testing without real credentials</p>
        </div>
    </div>

    <script>
        // Demo login for testing
        function demoLogin() {
            localStorage.setItem('auth_token', 'demo_token_12345');
            window.location.href = '/booking-payment';
        }

        // Handle form submission
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;

            // Simple validation
            if (email && password) {
                // In real app, make API call to authenticate
                localStorage.setItem('auth_token', 'user_token_' + Date.now());
                window.location.href = '/booking-payment';
            } else {
                alert('Please enter both email and password');
            }
        });

        // Check if already logged in
        if (localStorage.getItem('auth_token')) {
            window.location.href = '/booking-payment';
        }
    </script>
</body>
</html>
