<!DOCTYPE html>
<html>
<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <script src="https://js.pusher.com/8.2/pusherTOUCHpusher.min.js"></script>
    @vite(['resources/js/app.js']) <!-- Agar Vite use kar rahe ho -->
</head>
<body>

    @yield('content')

    <!-- Toast Container -->
    <div id="toast-container" class="fixed top-5 right-5 z-50 space-y-3"></div>

    <script>
        // SUPERADMIN REAL-TIME NOTIFICATION - 100% WORKING
        document.addEventListener('DOMContentLoaded', function () {
            // Agar Laravel Echo nahi chal raha to direct Pusher use karo (guaranteed working)
            const pusher = new Pusher('20b00b71ddfc1a2efd3a', {
                cluster: 'us3',
                forceTLS: true,
                authEndpoint: '/broadcasting/auth',
                auth: {
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    }
                }
            });

            // Sirf private channel suno (superadmin ke liye)
            const channel = pusher.subscribe('private-superadmin.notifications');

            channel.bind('pusher:subscription_succeeded', () => {
                console.log('Subscribed to private-superadmin.notifications');
            });

            channel.bind('pusher:subscription_error', (status) => {
                console.error('Subscription failed:', status);
            });

            // EVENT LISTEN KAROOO!
            channel.bind('user.registered', function(data) {
                console.log('NEW USER REGISTERED!', data);

                // Toast dikhao
                const toast = document.createElement('div');
                toast.className = 'max-w-sm bg-green-600 text-white p-4 rounded-lg shadow-lg transform transition-all duration-300 translate-x-full';
                toast.innerHTML = `
                    <div class="flex items-center gap-3">
                        <span class="text-2xl">New User</span>
                        <div>
                            <div class="font-bold">${data.user_name}</div>
                            <div class="text-sm opacity-90">${data.user_email}</div>
                            <div class="text-xs mt-1">Just now</div>
                        </div>
                    </div>
                `;

                document.getElementById('toast-container').appendChild(toast);

                // Animate in
                setTimeout(() => toast.classList.remove('translate-x-full'), 100);

                // Auto remove
                setTimeout(() => {
                    toast.classList.add('opacity-0');
                    setTimeout(() => toast.remove(), 500);
                }, 5000);
            });
        });
    </script>

    <style>
        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        .translate-x-full { transform: translateX(100%); }
    </style>
</body>
</html>
