<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

class UsersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get roles
        $superAdminRole = Role::where('role_name', 'super_admin')->first();
        $babysitterRole = Role::where('role_name', 'babysitter')->first();
        $parentRole = Role::where('role_name', 'parent')->first();

        $users = [
            [
                'email' => 'admin@example.com',
                'password_hash' => Hash::make('Admin123!'),
                'role_id' => $superAdminRole->role_id,
                'first_name' => 'System',
                'last_name' => 'Administrator',
                'phone_number' => '+1-555-0100',
                'is_email_verified' => true,
                'is_phone_verified' => true,
                'is_profile_completed' => true,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'email' => 'parent@example.com',
                'password_hash' => Hash::make('Parent123!'),
                'role_id' => $parentRole->role_id,
                'first_name' => 'Michael',
                'last_name' => 'Smith',
                'phone_number' => '+1-555-0102',
                'gender' => 'male',
                'date_of_birth' => '1985-08-20',
                'bio' => 'Looking for reliable childcare for my two wonderful kids.',
                'is_email_verified' => true,
                'is_phone_verified' => true,
                'is_profile_completed' => true,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'email' => 'babysitter@example.com',
                'password_hash' => Hash::make('Babysitter123!'),
                'role_id' => $babysitterRole->role_id,
                'first_name' => 'Sarah',
                'last_name' => 'Johnson',
                'phone_number' => '+1-555-0101',
                'gender' => 'female',
                'date_of_birth' => '1990-05-15',
                'bio' => 'Experienced babysitter with 5 years of experience caring for children of all ages.',
                'is_email_verified' => true,
                'is_phone_verified' => true,
                'is_profile_completed' => true,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],

        ];

        foreach ($users as $user) {
            User::create($user);
        }
    }
}
