<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\UserLanguage;
use App\Models\User;
use App\Models\Language;

class UserLanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('email', 'admin@sitly.ca')->first();
        $parent = User::where('email', 'parent@example.com')->first();
        $babysitter = User::where('email', 'babysitter@example.com')->first();

        $english = Language::where('language_code', 'en')->first();
        $french = Language::where('language_code', 'fr')->first();
        $spanish = Language::where('language_code', 'es')->first();
        $hindi = Language::where('language_code', 'hi')->first();

        $userLanguages = [
            // Admin Languages
            [
                'user_id' => $admin->user_id,
                'language_code' => 'en',
                'proficiency' => 'native',
                'is_primary' => true
            ],
            [
                'user_id' => $admin->user_id,
                'language_code' => 'fr',
                'proficiency' => 'intermediate',
                'is_primary' => false
            ],

            // Parent Languages
            [
                'user_id' => $parent->user_id,
                'language_code' => 'en',
                'proficiency' => 'native',
                'is_primary' => true
            ],
            [
                'user_id' => $parent->user_id,
                'language_code' => 'es',
                'proficiency' => 'basic',
                'is_primary' => false
            ],

            // Babysitter Languages
            [
                'user_id' => $babysitter->user_id,
                'language_code' => 'en',
                'proficiency' => 'fluent',
                'is_primary' => true
            ],
            [
                'user_id' => $babysitter->user_id,
                'language_code' => 'fr',
                'proficiency' => 'native',
                'is_primary' => false
            ],
            [
                'user_id' => $babysitter->user_id,
                'language_code' => 'hi',
                'proficiency' => 'intermediate',
                'is_primary' => false
            ]
        ];

        foreach ($userLanguages as $userLanguage) {
            UserLanguage::create($userLanguage);
        }
    }
}
