<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role;

class RolesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $roles = [
            [
                'role_name' => 'super_admin',
                'role_description' => 'System administrator with full access',
                'is_active' => true
            ],
            [
                'role_name' => 'parent',
                'role_description' => 'Child care service provider',
                'is_active' => true
            ],
            [
                'role_name' => 'babysitter',
                'role_description' => 'Parent looking for child care services',
                'is_active' => true
            ]
        ];

        foreach ($roles as $role) {
            Role::create($role);
        }
    }
}
