<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ParentProfile;
use App\Models\User;
use App\Models\Role;

class ParentProfilesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get parent role
        $parentRole = Role::where('role_name', 'parent')->first();

        if (!$parentRole) {
            $this->command->error('Parent role not found. Please run RolesTableSeeder first.');
            return;
        }

        $parentUsers = User::where('role_id', $parentRole->role_id)->get();

        if ($parentUsers->isEmpty()) {
            $this->command->error('No parent users found. Please create some parent users first.');
            return;
        }

        $parentProfiles = [
            [
                'user_id' => $parentUsers[0]->user_id,
                'family_description' => 'We are a family with two wonderful children aged 5 and 8. We love outdoor activities and reading books together.',
                'household_rules' => 'No smoking, limited screen time, healthy meals, bedtime at 8 PM for younger child.',
                'emergency_contacts' => 'Dr. Smith: +1-555-0101, Grandma: +1-555-0102, Neighbor: +1-555-0103',
                'preferred_communication' => 'in_app',
            ],
            [
                'user_id' => $parentUsers[1]->user_id ?? $parentUsers[0]->user_id,
                'family_description' => 'Single parent with one active 6-year-old boy who loves sports and arts & crafts.',
                'household_rules' => 'Homework before play, no sweets after 7 PM, respect for others and property.',
                'emergency_contacts' => 'Pediatrician: +1-555-0201, School: +1-555-0202, Best Friend: +1-555-0203',
                'preferred_communication' => 'phone',
            ],
            [
                'user_id' => $parentUsers[2]->user_id ?? $parentUsers[0]->user_id,
                'family_description' => 'We have twin 4-year-old girls and a newborn baby. We need help with the twins while we focus on the newborn.',
                'household_rules' => 'Strict nap schedule, allergy-aware household (no nuts), gentle discipline approach.',
                'emergency_contacts' => 'Hospital: +1-555-0301, Both grandparents on speed dial, Family doctor available 24/7',
                'preferred_communication' => 'email',
            ]
        ];

        foreach ($parentProfiles as $profile) {
            // Check if user exists and doesn't already have a profile
            $user = User::find($profile['user_id']);
            if ($user && !ParentProfile::where('user_id', $profile['user_id'])->exists()) {
                ParentProfile::create($profile);
                $this->command->info("Created parent profile for user: {$user->first_name} {$user->last_name}");
            }
        }

        $this->command->info('Parent profiles seeded successfully!');
    }
}
