<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\OccupationCategory;

class OccupationCategoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'category_name' => 'Full-time Nanny',
                'category_description' => 'Professional nanny for full-time child care',
                'category_type' => 'nanny',
                'base_hourly_rate' => 20.00,
                'min_experience_years' => 2,
                'sort_order' => 1,
            ],
            [
                'category_name' => 'Part-time Nanny',
                'category_description' => 'Nanny for part-time child care needs',
                'category_type' => 'nanny',
                'base_hourly_rate' => 18.00,
                'min_experience_years' => 1,
                'sort_order' => 2,
            ],
            [
                'category_name' => 'Home Worker',
                'category_description' => 'General home maintenance and cleaning',
                'category_type' => 'home_worker',
                'base_hourly_rate' => 16.00,
                'min_experience_years' => 0,
                'sort_order' => 3,
            ],
            [
                'category_name' => 'Elderly Care Assistant',
                'category_description' => 'Companion and care for elderly adults',
                'category_type' => 'elderly_care',
                'base_hourly_rate' => 17.00,
                'min_experience_years' => 1,
                'sort_order' => 4,
            ],
            [
                'category_name' => 'Pet Care Specialist',
                'category_description' => 'Professional pet sitting and care',
                'category_type' => 'pet_care',
                'base_hourly_rate' => 15.00,
                'min_experience_years' => 0,
                'sort_order' => 5,
            ],
            [
                'category_name' => 'Part-time House Helper',
                'category_description' => 'Part-time household assistance',
                'category_type' => 'house_helper',
                'base_hourly_rate' => 14.00,
                'min_experience_years' => 0,
                'sort_order' => 6,
            ],
            [
                'category_name' => 'Special Needs Care',
                'category_description' => 'Specialized care for special needs individuals',
                'category_type' => 'special_needs_care',
                'base_hourly_rate' => 22.00,
                'min_experience_years' => 3,
                'sort_order' => 7,
            ],
        ];

        foreach ($categories as $category) {
            OccupationCategory::create($category);
        }
    }
}
