<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\LanguageTranslation;

class LanguageTranslationsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $translations = [
            // =============================================
            // ENGLISH TRANSLATIONS
            // =============================================

            // Home Page Section
            [
                'language_code' => 'en',
                'translation_key' => 'welcome_message',
                'translation_value' => 'Welcome to Sitly.ca',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'tagline',
                'translation_value' => 'Find Trusted Babysitters & Caregivers',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'find_babysitter',
                'translation_value' => 'Find a Babysitter',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'become_babysitter',
                'translation_value' => 'Become a Babysitter',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'how_it_works',
                'translation_value' => 'How It Works',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'trusted_by_families',
                'translation_value' => 'Trusted by Thousands of Families',
                'page_section' => 'home'
            ],

            // Authentication Section
            [
                'language_code' => 'en',
                'translation_key' => 'login',
                'translation_value' => 'Login',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'register',
                'translation_value' => 'Register',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'logout',
                'translation_value' => 'Logout',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'email',
                'translation_value' => 'Email',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'password',
                'translation_value' => 'Password',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'confirm_password',
                'translation_value' => 'Confirm Password',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'remember_me',
                'translation_value' => 'Remember Me',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'forgot_password',
                'translation_value' => 'Forgot Your Password?',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'reset_password',
                'translation_value' => 'Reset Password',
                'page_section' => 'auth'
            ],

            // Navigation Section
            [
                'language_code' => 'en',
                'translation_key' => 'home',
                'translation_value' => 'Home',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'search',
                'translation_value' => 'Search',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'messages',
                'translation_value' => 'Messages',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'bookings',
                'translation_value' => 'Bookings',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'profile',
                'translation_value' => 'Profile',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'settings',
                'translation_value' => 'Settings',
                'page_section' => 'navigation'
            ],

            // User Profile Section
            [
                'language_code' => 'en',
                'translation_key' => 'first_name',
                'translation_value' => 'First Name',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'last_name',
                'translation_value' => 'Last Name',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'phone_number',
                'translation_value' => 'Phone Number',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'date_of_birth',
                'translation_value' => 'Date of Birth',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'gender',
                'translation_value' => 'Gender',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'bio',
                'translation_value' => 'Bio',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'save_changes',
                'translation_value' => 'Save Changes',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'update_profile',
                'translation_value' => 'Update Profile',
                'page_section' => 'profile'
            ],

            // Babysitter Profile Section
            [
                'language_code' => 'en',
                'translation_key' => 'hourly_rate',
                'translation_value' => 'Hourly Rate',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'experience_years',
                'translation_value' => 'Years of Experience',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'availability',
                'translation_value' => 'Availability',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'about_me',
                'translation_value' => 'About Me',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'languages_spoken',
                'translation_value' => 'Languages Spoken',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'certifications',
                'translation_value' => 'Certifications',
                'page_section' => 'babysitter'
            ],

            // Parent Profile Section
            [
                'language_code' => 'en',
                'translation_key' => 'family_description',
                'translation_value' => 'Family Description',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'household_rules',
                'translation_value' => 'Household Rules',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'emergency_contacts',
                'translation_value' => 'Emergency Contacts',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'children_info',
                'translation_value' => 'Children Information',
                'page_section' => 'parent'
            ],

            // Booking Section
            [
                'language_code' => 'en',
                'translation_key' => 'book_now',
                'translation_value' => 'Book Now',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'request_booking',
                'translation_value' => 'Request Booking',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'start_date',
                'translation_value' => 'Start Date',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'end_date',
                'translation_value' => 'End Date',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'hours_per_week',
                'translation_value' => 'Hours per Week',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'booking_details',
                'translation_value' => 'Booking Details',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'total_amount',
                'translation_value' => 'Total Amount',
                'page_section' => 'booking'
            ],

            // Common Buttons & Actions
            [
                'language_code' => 'en',
                'translation_key' => 'save',
                'translation_value' => 'Save',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'cancel',
                'translation_value' => 'Cancel',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'delete',
                'translation_value' => 'Delete',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'edit',
                'translation_value' => 'Edit',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'view',
                'translation_value' => 'View',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'submit',
                'translation_value' => 'Submit',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'continue',
                'translation_value' => 'Continue',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'back',
                'translation_value' => 'Back',
                'page_section' => 'common'
            ],

            // Messages & Notifications
            [
                'language_code' => 'en',
                'translation_key' => 'success',
                'translation_value' => 'Success',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'error',
                'translation_value' => 'Error',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'warning',
                'translation_value' => 'Warning',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'info',
                'translation_value' => 'Information',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'profile_updated',
                'translation_value' => 'Profile updated successfully',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'booking_created',
                'translation_value' => 'Booking created successfully',
                'page_section' => 'messages'
            ],

            // =============================================
            // FRENCH TRANSLATIONS (FRANÇAIS)
            // =============================================

            // Home Page Section
            [
                'language_code' => 'fr',
                'translation_key' => 'welcome_message',
                'translation_value' => 'Bienvenue sur Sitly.ca',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'tagline',
                'translation_value' => 'Trouvez des Babysitters et Aidants de Confiance',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'find_babysitter',
                'translation_value' => 'Trouver une Babysitter',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'become_babysitter',
                'translation_value' => 'Devenir Babysitter',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'how_it_works',
                'translation_value' => 'Comment ça Marche',
                'page_section' => 'home'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'trusted_by_families',
                'translation_value' => 'De Confiance par des Milliers de Familles',
                'page_section' => 'home'
            ],

            // Authentication Section
            [
                'language_code' => 'fr',
                'translation_key' => 'login',
                'translation_value' => 'Connexion',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'register',
                'translation_value' => 'Inscription',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'logout',
                'translation_value' => 'Déconnexion',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'email',
                'translation_value' => 'E-mail',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'password',
                'translation_value' => 'Mot de passe',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'confirm_password',
                'translation_value' => 'Confirmer le mot de passe',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'remember_me',
                'translation_value' => 'Se souvenir de moi',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'forgot_password',
                'translation_value' => 'Mot de passe oublié?',
                'page_section' => 'auth'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'reset_password',
                'translation_value' => 'Réinitialiser le mot de passe',
                'page_section' => 'auth'
            ],

            // Navigation Section
            [
                'language_code' => 'fr',
                'translation_key' => 'home',
                'translation_value' => 'Accueil',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'search',
                'translation_value' => 'Rechercher',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'messages',
                'translation_value' => 'Messages',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'bookings',
                'translation_value' => 'Réservations',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'profile',
                'translation_value' => 'Profil',
                'page_section' => 'navigation'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'settings',
                'translation_value' => 'Paramètres',
                'page_section' => 'navigation'
            ],

            // User Profile Section
            [
                'language_code' => 'fr',
                'translation_key' => 'first_name',
                'translation_value' => 'Prénom',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'last_name',
                'translation_value' => 'Nom de famille',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'phone_number',
                'translation_value' => 'Numéro de téléphone',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'date_of_birth',
                'translation_value' => 'Date de naissance',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'gender',
                'translation_value' => 'Genre',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'bio',
                'translation_value' => 'Biographie',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'save_changes',
                'translation_value' => 'Sauvegarder les modifications',
                'page_section' => 'profile'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'update_profile',
                'translation_value' => 'Mettre à jour le profil',
                'page_section' => 'profile'
            ],

            // Babysitter Profile Section
            [
                'language_code' => 'fr',
                'translation_key' => 'hourly_rate',
                'translation_value' => 'Taux horaire',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'experience_years',
                'translation_value' => "Années d'expérience",
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'availability',
                'translation_value' => 'Disponibilité',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'about_me',
                'translation_value' => 'À propos de moi',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'languages_spoken',
                'translation_value' => 'Langues parlées',
                'page_section' => 'babysitter'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'certifications',
                'translation_value' => 'Certifications',
                'page_section' => 'babysitter'
            ],

            // Parent Profile Section
            [
                'language_code' => 'fr',
                'translation_key' => 'family_description',
                'translation_value' => 'Description de la famille',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'household_rules',
                'translation_value' => 'Règles de la maison',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'emergency_contacts',
                'translation_value' => 'Contacts d\'urgence',
                'page_section' => 'parent'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'children_info',
                'translation_value' => 'Informations sur les enfants',
                'page_section' => 'parent'
            ],

            // Booking Section
            [
                'language_code' => 'fr',
                'translation_key' => 'book_now',
                'translation_value' => 'Réserver maintenant',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'request_booking',
                'translation_value' => 'Demander une réservation',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'start_date',
                'translation_value' => 'Date de début',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'end_date',
                'translation_value' => 'Date de fin',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'hours_per_week',
                'translation_value' => 'Heures par semaine',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'booking_details',
                'translation_value' => 'Détails de la réservation',
                'page_section' => 'booking'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'total_amount',
                'translation_value' => 'Montant total',
                'page_section' => 'booking'
            ],

            // Common Buttons & Actions
            [
                'language_code' => 'fr',
                'translation_key' => 'save',
                'translation_value' => 'Sauvegarder',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'cancel',
                'translation_value' => 'Annuler',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'delete',
                'translation_value' => 'Supprimer',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'edit',
                'translation_value' => 'Modifier',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'view',
                'translation_value' => 'Voir',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'submit',
                'translation_value' => 'Soumettre',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'continue',
                'translation_value' => 'Continuer',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'back',
                'translation_value' => 'Retour',
                'page_section' => 'common'
            ],

            // Messages & Notifications
            [
                'language_code' => 'fr',
                'translation_key' => 'success',
                'translation_value' => 'Succès',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'error',
                'translation_value' => 'Erreur',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'warning',
                'translation_value' => 'Avertissement',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'info',
                'translation_value' => 'Information',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'profile_updated',
                'translation_value' => 'Profil mis à jour avec succès',
                'page_section' => 'messages'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'booking_created',
                'translation_value' => 'Réservation créée avec succès',
                'page_section' => 'messages'
            ],

            // Additional Common Terms
            [
                'language_code' => 'en',
                'translation_key' => 'loading',
                'translation_value' => 'Loading...',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'loading',
                'translation_value' => 'Chargement...',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'no_data',
                'translation_value' => 'No data available',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'no_data',
                'translation_value' => 'Aucune donnée disponible',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'search_placeholder',
                'translation_value' => 'Search...',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'search_placeholder',
                'translation_value' => 'Rechercher...',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'en',
                'translation_key' => 'select_option',
                'translation_value' => 'Select an option',
                'page_section' => 'common'
            ],
            [
                'language_code' => 'fr',
                'translation_key' => 'select_option',
                'translation_value' => 'Sélectionner une option',
                'page_section' => 'common'
            ],
        ];

        foreach ($translations as $translation) {
            // Check if translation already exists to avoid duplicates
            $existing = LanguageTranslation::where('language_code', $translation['language_code'])
                ->where('translation_key', $translation['translation_key'])
                ->first();

            if (!$existing) {
                LanguageTranslation::create($translation);
            }
        }

        $this->command->info('Language translations seeded successfully!');
        $this->command->info('English translations: ' . count(array_filter($translations, function($item) {
            return $item['language_code'] === 'en';
        })));
        $this->command->info('French translations: ' . count(array_filter($translations, function($item) {
            return $item['language_code'] === 'fr';
        })));
    }
}
