<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Language;

class LanguageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $languages = [
            [
                'language_code' => 'en',
                'language_name' => 'English',
                'native_name' => 'English',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'language_code' => 'fr',
                'language_name' => 'French',
                'native_name' => 'Français',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'language_code' => 'es',
                'language_name' => 'Spanish',
                'native_name' => 'Español',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'language_code' => 'de',
                'language_name' => 'German',
                'native_name' => 'Deutsch',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'language_code' => 'it',
                'language_name' => 'Italian',
                'native_name' => 'Italiano',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'language_code' => 'pt',
                'language_name' => 'Portuguese',
                'native_name' => 'Português',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 6
            ],
            [
                'language_code' => 'ru',
                'language_name' => 'Russian',
                'native_name' => 'Русский',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 7
            ],
            [
                'language_code' => 'zh',
                'language_name' => 'Chinese',
                'native_name' => '中文',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 8
            ],
            [
                'language_code' => 'ja',
                'language_name' => 'Japanese',
                'native_name' => '日本語',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 9
            ],
            [
                'language_code' => 'ar',
                'language_name' => 'Arabic',
                'native_name' => 'العربية',
                'is_rtl' => true,
                'is_active' => true,
                'sort_order' => 10
            ],
            [
                'language_code' => 'hi',
                'language_name' => 'Hindi',
                'native_name' => 'हिन्दी',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 11
            ],
            [
                'language_code' => 'bn',
                'language_name' => 'Bengali',
                'native_name' => 'বাংলা',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 12
            ],
            [
                'language_code' => 'pa',
                'language_name' => 'Punjabi',
                'native_name' => 'ਪੰਜਾਬੀ',
                'is_rtl' => false,
                'is_active' => true,
                'sort_order' => 13
            ],
            [
                'language_code' => 'ur',
                'language_name' => 'Urdu',
                'native_name' => 'اردو',
                'is_rtl' => true,
                'is_active' => true,
                'sort_order' => 14
            ]
        ];

        foreach ($languages as $language) {
            Language::create($language);
        }
    }
}
