<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CommissionRate;
use App\Models\User;

class CommissionRateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('email', 'admin@sitly.ca')->first();

        $commissionRates = [
            [
                'commission_name' => 'Standard Commission',
                'commission_type' => 'percentage',
                'commission_value' => 15.00,
                'min_amount' => 0,
                'max_amount' => null,
                'applicable_to' => 'all',
                'booking_type' => 'all',
                'is_active' => true,
                'effective_from' => now()->subDays(30),
                'effective_to' => null,
                'created_by' => $admin->user_id
            ],
            [
                'commission_name' => 'Full-time Nanny Commission',
                'commission_type' => 'percentage',
                'commission_value' => 12.00,
                'min_amount' => 0,
                'max_amount' => null,
                'applicable_to' => 'nanny',
                'booking_type' => 'full_time',
                'is_active' => true,
                'effective_from' => now()->subDays(30),
                'effective_to' => null,
                'created_by' => $admin->user_id
            ],
            [
                'commission_name' => 'Part-time Commission',
                'commission_type' => 'percentage',
                'commission_value' => 16.00,
                'min_amount' => 0,
                'max_amount' => null,
                'applicable_to' => 'all',
                'booking_type' => 'part_time',
                'is_active' => true,
                'effective_from' => now()->subDays(30),
                'effective_to' => null,
                'created_by' => $admin->user_id
            ],
            [
                'commission_name' => 'Temporary Commission',
                'commission_type' => 'percentage',
                'commission_value' => 14.00,
                'min_amount' => 0,
                'max_amount' => null,
                'applicable_to' => 'all',
                'booking_type' => 'temporary',
                'is_active' => true,
                'effective_from' => now()->subDays(30),
                'effective_to' => null,
                'created_by' => $admin->user_id
            ],
            [
                'commission_name' => 'Special Needs Commission',
                'commission_type' => 'percentage',
                'commission_value' => 13.00,
                'min_amount' => 0,
                'max_amount' => null,
                'applicable_to' => 'special_needs_care',
                'booking_type' => 'all',
                'is_active' => true,
                'effective_from' => now()->subDays(30),
                'effective_to' => null,
                'created_by' => $admin->user_id
            ]
        ];

        foreach ($commissionRates as $rate) {
            CommissionRate::create($rate);
        }
    }
}
