<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\CareRecipient;
use App\Models\ParentProfile;
use App\Models\User;

class CareRecipientsTableSeeder extends Seeder
{
    public function run(): void
    {
        // Get parent user
        $parentUser = User::where('email', 'parent@example.com')->first();

        if (!$parentUser) {
            $this->command->error('Parent user not found. Please run UsersTableSeeder first.');
            return;
        }

        $parentProfile = ParentProfile::where('user_id', $parentUser->user_id)->first();

        if (!$parentProfile) {
            $this->command->error('Parent profile not found. Please run ParentProfilesTableSeeder first.');
            return;
        }

        $careRecipients = [
            // Children
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'child',
                'name' => 'Emma Smith',
                'age' => 5,
                'gender' => 'female',
                'health_mobility_details' => 'Healthy and active child. Loves outdoor activities.',
                'special_instructions' => 'No screen time after 7 PM. Bedtime at 8:30 PM.',
                'allergies' => 'Peanuts, dairy',
                'medications' => 'Children\'s vitamins daily',
                'is_active' => true,
            ],
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'child',
                'name' => 'Noah Smith',
                'age' => 3,
                'gender' => 'male',
                'health_mobility_details' => 'Toddler, still in diapers. Learning to talk.',
                'special_instructions' => 'Nap time from 1 PM to 3 PM. Favorite toy is teddy bear.',
                'allergies' => 'None',
                'medications' => 'None',
                'is_active' => true,
            ],
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'child',
                'name' => 'Sophia Smith',
                'age' => 8,
                'gender' => 'female',
                'health_mobility_details' => 'Active in sports. Has asthma.',
                'special_instructions' => 'Homework help needed. Loves reading books.',
                'allergies' => 'Dust mites, pollen',
                'medications' => 'Asthma inhaler as needed',
                'is_active' => true,
            ],

            // Elderly care recipient
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'elderly',
                'name' => 'Margaret Johnson',
                'age' => 78,
                'gender' => 'female',
                'health_mobility_details' => 'Uses walker for mobility. Mild memory issues.',
                'special_instructions' => 'Needs assistance with medication management. Enjoys conversation.',
                'allergies' => 'Penicillin',
                'medications' => 'Blood pressure medication, memory supplements',
                'is_active' => true,
            ],

            // Special needs child
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'special_needs',
                'name' => 'Lucas Smith',
                'age' => 6,
                'gender' => 'male',
                'health_mobility_details' => 'Autism spectrum. Non-verbal but understands instructions.',
                'special_instructions' => 'Uses picture cards for communication. Sensitive to loud noises.',
                'allergies' => 'Gluten',
                'medications' => 'Therapy sessions twice weekly',
                'is_active' => true,
            ],

            // Pet care
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'pet',
                'name' => 'Max',
                'age' => 4,
                'gender' => 'male',
                'health_mobility_details' => 'Golden Retriever. Very friendly and well-trained.',
                'special_instructions' => 'Needs two walks daily. Favorite treats in blue container.',
                'allergies' => 'Chicken',
                'medications' => 'Flea and tick prevention monthly',
                'is_active' => true,
            ],
            [
                'parent_id' => $parentProfile->profile_id,
                'recipient_type' => 'pet',
                'name' => 'Luna',
                'age' => 2,
                'gender' => 'female',
                'health_mobility_details' => 'Siamese cat. Indoor only.',
                'special_instructions' => 'Litter box cleaning twice daily. Play with feather toy.',
                'allergies' => 'Fish-based food',
                'medications' => 'None',
                'is_active' => true,
            ],
        ];

        foreach ($careRecipients as $recipient) {
            CareRecipient::create($recipient);
        }

        $this->command->info('Care recipients seeded successfully!');
        $this->command->info('Total care recipients: ' . count($careRecipients));

        // Show breakdown by type
        $types = array_count_values(array_column($careRecipients, 'recipient_type'));
        foreach ($types as $type => $count) {
            $this->command->info(" - {$type}: {$count}");
        }
    }
}
