<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\BookingType;

class BookingTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $bookingTypes = [
            [
                'type_name' => 'Full Time Permanent',
                'type_description' => 'Long-term full-time employment (11 months minimum)',
                'min_duration_days' => 330,
                'max_duration_days' => null,
                'requires_contract' => true,
                'is_active' => true
            ],
            [
                'type_name' => 'Temporary',
                'type_description' => 'Temporary care from 1 month to 1 year',
                'min_duration_days' => 30,
                'max_duration_days' => 365,
                'requires_contract' => true,
                'is_active' => true
            ],
            [
                'type_name' => 'Part Time Weekly',
                'type_description' => 'Regular part-time weekly schedule',
                'min_duration_days' => 7,
                'max_duration_days' => null,
                'requires_contract' => false,
                'is_active' => true
            ],
            [
                'type_name' => 'Part Time Hourly',
                'type_description' => 'Flexible hourly bookings',
                'min_duration_days' => 1,
                'max_duration_days' => null,
                'requires_contract' => false,
                'is_active' => true
            ],
            [
                'type_name' => 'One-time Service',
                'type_description' => 'Single day or one-time service booking',
                'min_duration_days' => 1,
                'max_duration_days' => 1,
                'requires_contract' => false,
                'is_active' => true
            ]
        ];

        foreach ($bookingTypes as $type) {
            BookingType::create($type);
        }
    }
}
