<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('direct_booking_requests', function (Blueprint $table) {
            $table->enum('payment_status', ['pending', 'success', 'failed'])
                  ->nullable()
                  ->default('pending')
                  ->after('request_status');
        });
    }

    public function down(): void
    {
        Schema::table('direct_booking_requests', function (Blueprint $table) {
            $table->dropColumn('payment_status');
        });
    }
};
