<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Fix payment_method ENUM
            $table->enum('payment_method', [
                'credit_card',
                'debit_card',
                'paypal',
                'bank_transfer',
                'razorpay',
                'cash'
            ])->default('credit_card')->change();

            // Fix payment_status ENUM
            $table->enum('payment_status', [
                'pending',
                'processing',
                'completed',
                'failed',
                'refunded'
            ])->default('pending')->change();

            // Set default values for decimal columns
            $table->decimal('subtotal_amount', 10, 2)->default(0.00)->change();
            $table->decimal('commission_rate', 5, 2)->default(0.00)->change();
            $table->decimal('commission_amount', 10, 2)->default(0.00)->change();
            $table->decimal('babysitter_payout_amount', 10, 2)->default(0.00)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Revert changes if needed
            $table->enum('payment_method', [
                'credit_card',
                'debit_card',
                'paypal',
                'bank_transfer',
                'cash'
            ])->change();

            $table->enum('payment_status', [
                'pending',
                'processing',
                'completed',
                'failed'
            ])->change();

            $table->decimal('subtotal_amount', 10, 2)->default(null)->change();
            $table->decimal('commission_rate', 5, 2)->default(null)->change();
            $table->decimal('commission_amount', 10, 2)->default(null)->change();
            $table->decimal('babysitter_payout_amount', 10, 2)->default(null)->change();
        });
    }
};
