<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Set default values for NOT NULL columns
            $table->decimal('subtotal_amount', 10, 2)->default(0.00)->change();
            $table->decimal('commission_rate', 5, 2)->default(0.00)->change();
            $table->decimal('commission_amount', 10, 2)->default(0.00)->change();
            $table->decimal('babysitter_payout_amount', 10, 2)->default(0.00)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Revert back to no default values
            $table->decimal('subtotal_amount', 10, 2)->default(null)->change();
            $table->decimal('commission_rate', 5, 2)->default(null)->change();
            $table->decimal('commission_amount', 10, 2)->default(null)->change();
            $table->decimal('babysitter_payout_amount', 10, 2)->default(null)->change();
        });
    }
};
