<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Add base_currency_amount column
            if (!Schema::hasColumn('payments', 'base_currency_amount')) {
                $table->decimal('base_currency_amount', 10, 2)->nullable()->after('currency');
            }

            // Add razorpay_order_id column
            if (!Schema::hasColumn('payments', 'razorpay_order_id')) {
                $table->string('razorpay_order_id')->nullable()->after('payment_gateway');
            }

            // Also check if exchange_rate is missing (mentioned in your model)
            if (!Schema::hasColumn('payments', 'exchange_rate')) {
                $table->decimal('exchange_rate', 10, 6)->nullable()->after('currency');
            }

            // Add razorpay_payment_id if missing
            if (!Schema::hasColumn('payments', 'razorpay_payment_id')) {
                $table->string('razorpay_payment_id')->nullable()->after('razorpay_order_id');
            }

            // Add razorpay_signature if missing
            if (!Schema::hasColumn('payments', 'razorpay_signature')) {
                $table->string('razorpay_signature')->nullable()->after('razorpay_payment_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            $table->dropColumn([
                'base_currency_amount',
                'exchange_rate',
                'razorpay_order_id',
                'razorpay_payment_id',
                'razorpay_signature'
            ]);
        });
    }
};
