<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('report_templates', function (Blueprint $table) {
            $table->id('template_id');

            // Template Details
            $table->string('template_name', 255);
            $table->enum('template_type', ['financial', 'user', 'booking', 'commission', 'performance', 'system']);
            $table->text('template_query');
            $table->json('parameters')->nullable();

            // Status
            $table->boolean('is_active')->default(true);

            // Foreign Keys
            $table->foreignId('created_by')->constrained('users', 'user_id')->onDelete('restrict');

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('template_type');
            $table->index('is_active');
            $table->index('created_by');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('report_templates');
    }
};
