<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->id('report_id');

            // Report Details
            $table->string('report_name', 255);
            $table->enum('report_type', ['financial', 'user', 'booking', 'commission', 'performance', 'system']);
            $table->json('report_data');

            // Date Range
            $table->date('date_range_start')->nullable();
            $table->date('date_range_end')->nullable();

            // Foreign Keys
            $table->foreignId('generated_by')->constrained('users', 'user_id')->onDelete('restrict');

            // Status
            $table->boolean('is_archived')->default(false);

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('report_type');
            $table->index(['date_range_start', 'date_range_end']);
            $table->index('generated_by');
            $table->index('is_archived');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reports');
    }
};
