<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('content_pages', function (Blueprint $table) {
            $table->id('page_id');

            // Page Details
            $table->string('page_title', 255);
            $table->string('page_slug', 255)->unique();
            $table->longText('page_content');
            $table->string('meta_title', 255)->nullable();
            $table->text('meta_description')->nullable();
            $table->enum('page_type', ['about', 'privacy', 'terms', 'faq', 'contact', 'home', 'general'])->default('general');

            // Status
            $table->boolean('is_published')->default(true);
            $table->integer('sort_order')->default(0);

            // Foreign Keys
            $table->foreignId('created_by')->constrained('users', 'user_id')->onDelete('restrict');

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('page_slug');
            $table->index('page_type');
            $table->index('is_published');
            $table->index('sort_order');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('content_pages');
    }
};
