<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('babysitter_skills', function (Blueprint $table) {
            $table->id('skill_id');

            // Foreign Keys
            $table->foreignId('babysitter_id')->constrained('babysitter_profiles', 'profile_id')->onDelete('cascade');

            // Skill Details
            $table->enum('skill_type', ['certification', 'skill', 'language', 'specialty']);
            $table->string('skill_name', 255);
            $table->enum('skill_level', ['beginner', 'intermediate', 'advanced', 'expert'])->nullable();
            $table->string('certificate_url', 500)->nullable();
            $table->string('issuing_organization', 255)->nullable();
            $table->date('issue_date')->nullable();
            $table->date('expiry_date')->nullable();
            $table->boolean('is_verified')->default(false);

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('babysitter_id');
            $table->index('skill_type');
            $table->index('skill_name');
            $table->index('is_verified');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('babysitter_skills');
    }
};
