<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reviews', function (Blueprint $table) {
            $table->id('review_id');

            // Foreign Keys
            $table->foreignId('booking_id')->constrained('bookings', 'booking_id')->onDelete('restrict');
            $table->foreignId('reviewer_id')->constrained('users', 'user_id')->onDelete('restrict');
            $table->foreignId('reviewed_user_id')->constrained('users', 'user_id')->onDelete('restrict');

            // Review Details
            $table->enum('review_type', ['parent_to_babysitter', 'babysitter_to_parent']);
            $table->integer('rating')->check('rating >= 1 AND rating <= 5');
            $table->text('review_text')->nullable();
            $table->boolean('would_recommend')->nullable();
            $table->text('strengths')->nullable();
            $table->text('areas_for_improvement')->nullable();

            // Review Status
            $table->boolean('is_public')->default(true);
            $table->boolean('is_verified_booking')->default(true);
            $table->integer('helpful_count')->default(0);
            $table->integer('reported_count')->default(0);

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->unique('booking_id');
            $table->index('review_type');
            $table->index('rating');
            $table->index('reviewed_user_id');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reviews');
    }
};
