<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payouts', function (Blueprint $table) {
            $table->id('payout_id');

            // Foreign Keys
            $table->foreignId('babysitter_id')->constrained('users', 'user_id')->onDelete('restrict');
            $table->foreignId('payment_id')->constrained('payments', 'payment_id')->onDelete('restrict');

            // Payout Details
            $table->decimal('amount', 10, 2);
            $table->enum('payout_method', ['bank_transfer', 'paypal', 'interac', 'check', 'cash']);
            $table->enum('payout_status', ['pending', 'processing', 'completed', 'failed'])->default('pending');

            // Payout References
            $table->string('payout_reference', 255)->nullable();
            $table->text('payout_notes')->nullable();

            // Timeline
            $table->date('scheduled_payout_date');
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamp('failed_at')->nullable();

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('payout_status');
            $table->index('babysitter_id');
            $table->index('payment_id');
            $table->index('scheduled_payout_date');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payouts');
    }
};
