<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id('payment_id');

            // Foreign Keys
            $table->foreignId('booking_id')->constrained('bookings', 'booking_id')->onDelete('restrict');
            $table->foreignId('parent_id')->constrained('users', 'user_id')->onDelete('restrict');
            $table->foreignId('babysitter_id')->constrained('users', 'user_id')->onDelete('restrict');

            // Payment Amount Details
            $table->decimal('amount', 10, 2);
            $table->decimal('subtotal_amount', 10, 2);
            $table->decimal('commission_rate', 5, 2);
            $table->decimal('commission_amount', 10, 2);
            $table->decimal('babysitter_payout_amount', 10, 2);

            // Payment Method Details
            $table->enum('payment_method', ['credit_card', 'debit_card', 'paypal', 'interac', 'bank_transfer', 'cash']);
            $table->string('payment_gateway', 100)->nullable();
            $table->string('transaction_id', 255)->nullable();
            $table->text('gateway_response')->nullable();

            // Payment Status
            $table->enum('payment_status', ['pending', 'processing', 'completed', 'failed', 'refunded', 'cancelled'])->default('pending');

            // Timeline Tracking
            $table->timestamp('paid_at')->nullable();
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('payout_sent_at')->nullable();
            $table->timestamp('refunded_at')->nullable();

            // Audit Fields
            $table->timestamps();

            // Indexes
            $table->index('payment_status');
            $table->index(['paid_at', 'processed_at']);
            $table->index('booking_id');
            $table->index('parent_id');
            $table->index('babysitter_id');
            $table->index('transaction_id');
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
