<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('commission_earnings', function (Blueprint $table) {
            $table->id('earning_id');
            $table->foreignId('booking_id')->constrained('bookings', 'booking_id');
            $table->decimal('commission_rate', 5, 2);
            $table->decimal('commission_amount', 10, 2);
            $table->enum('earning_status', ['pending', 'processed', 'paid_out'])->default('pending');
            $table->timestamp('processed_at')->nullable();
            $table->timestamp('paid_out_at')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('commission_earnings');
    }
};
