<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('bookings', function (Blueprint $table) {
            $table->id('booking_id');

            // Foreign keys
            $table->foreignId('booking_request_id')->constrained('direct_booking_requests', 'booking_request_id');
            $table->foreignId('parent_id')->constrained('users', 'user_id');
            $table->foreignId('babysitter_id')->constrained('users', 'user_id');
            $table->foreignId('booking_type_id')->constrained('booking_types', 'type_id');
            $table->foreignId('occupation_category_id')->constrained('occupation_categories', 'category_id');

            // Booking Details
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->integer('total_weeks');
            $table->integer('expected_hours_per_week');
            $table->decimal('agreed_hourly_rate', 8, 2);
            $table->decimal('total_hours', 10, 2);
            $table->decimal('subtotal_amount', 10, 2);
            $table->decimal('commission_rate', 5, 2);
            $table->decimal('commission_amount', 10, 2);
            $table->decimal('total_amount', 10, 2);
            $table->decimal('babysitter_earnings', 10, 2);

            // Status Management
            $table->enum('booking_status', ['pending_payment', 'confirmed', 'active', 'completed', 'cancelled', 'refunded'])->default('pending_payment');
            $table->enum('payment_status', ['pending', 'processing', 'paid', 'failed', 'refunded'])->default('pending');

            // Timeline Tracking
            $table->timestamp('scheduled_completion_at')->nullable();
            $table->timestamp('confirmed_at')->nullable();
            $table->timestamp('payment_made_at')->nullable();
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamp('cancelled_at')->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['booking_status', 'payment_status']);
            $table->index('scheduled_completion_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
