<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('direct_booking_requests', function (Blueprint $table) {
            $table->id('booking_request_id');

            // Foreign keys
            $table->foreignId('parent_id')->constrained('users', 'user_id');
            $table->foreignId('babysitter_id')->constrained('users', 'user_id');
            $table->foreignId('booking_type_id')->constrained('booking_types', 'type_id');
            $table->foreignId('occupation_category_id')->constrained('occupation_categories', 'category_id');

            // Booking Details
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->integer('expected_hours_per_week');
            $table->decimal('hourly_rate', 8, 2);
            $table->decimal('total_expected_amount', 10, 2)->nullable();

            // Care Recipient Information
            $table->enum('care_type', ['child_care', 'elderly_care', 'special_needs_care', 'pet_care']);
            $table->integer('number_of_recipients')->default(1);
            $table->text('recipient_names')->nullable();
            $table->text('recipient_ages')->nullable();
            $table->enum('gender_preference', ['male', 'female', 'any'])->default('any');
            $table->text('health_mobility_details')->nullable();
            $table->text('special_instructions_allergies')->nullable();

            // Status Management
            $table->enum('request_status', ['pending', 'accepted', 'rejected', 'expired', 'cancelled'])->default('pending');
            $table->timestamp('expires_at')->nullable();

            // Timeline Tracking
            $table->timestamp('parent_submitted_at')->useCurrent();
            $table->timestamp('babysitter_viewed_at')->nullable();
            $table->timestamp('babysitter_responded_at')->nullable();

            $table->timestamps();

            // Indexes
            $table->index(['request_status', 'expires_at']);
            $table->index(['babysitter_id', 'request_status']);

            // Foreign key for currency
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('direct_booking_requests');
    }
};
