<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('care_recipients', function (Blueprint $table) {
            $table->id('recipient_id');
            $table->foreignId('parent_id')->constrained('parent_profiles', 'profile_id');
            $table->enum('recipient_type', ['child', 'elderly', 'special_needs', 'pet']);
            $table->string('name', 100);
            $table->integer('age')->nullable();
            $table->enum('gender', ['male', 'female', 'other', 'any'])->nullable();
            $table->text('health_mobility_details')->nullable();
            $table->text('special_instructions')->nullable();
            $table->text('allergies')->nullable();
            $table->text('medications')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('care_recipients');
    }
};
