<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('language_translations', function (Blueprint $table) {
            $table->id('translation_id');
            $table->string('language_code', 10);
            $table->string('translation_key', 255);
            $table->text('translation_value');
            $table->string('page_section', 100)->nullable();
            $table->timestamps();

            $table->foreign('language_code')->references('language_code')->on('languages');
            $table->unique(['language_code', 'translation_key']);
            $table->index('translation_key');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('language_translations');
    }
};
