<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_languages', function (Blueprint $table) {
            $table->id('user_language_id');
            $table->foreignId('user_id')->constrained('users', 'user_id');
            $table->string('language_code', 10);
            $table->enum('proficiency', ['basic', 'intermediate', 'fluent', 'native'])->default('intermediate');
            $table->boolean('is_primary')->default(false);
            $table->timestamps();

            // Foreign key for language_code
            $table->foreign('language_code')->references('language_code')->on('languages');

            // Unique constraint
            $table->unique(['user_id', 'language_code']);

            // Indexes
            $table->index(['user_id', 'is_primary']);
            $table->index('language_code');
            $table->index('proficiency');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_languages');
    }
};
