<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->id('address_id');
            $table->foreignId('user_id')->constrained('users', 'user_id');
            $table->enum('address_type', ['home', 'work', 'other'])->default('home');
            $table->string('street_address', 255);
            $table->foreignId('city_id')->constrained('cities', 'city_id');
            $table->foreignId('province_id')->constrained('provinces', 'province_id');
            $table->foreignId('country_id')->constrained('countries', 'country_id');
            $table->string('postal_code', 20);
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->boolean('is_primary')->default(false);
            $table->timestamps();

            // Indexes
            $table->index(['user_id', 'is_primary']);
            $table->index(['latitude', 'longitude']);
            $table->index(['city_id', 'province_id']);
            $table->index('postal_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('addresses');
    }
};
