<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('booking_types', function (Blueprint $table) {
            $table->id('type_id');
            $table->string('type_name', 100);
            $table->text('type_description')->nullable();
            $table->integer('min_duration_days')->default(1);
            $table->integer('max_duration_days')->nullable();
            $table->boolean('requires_contract')->default(false);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Indexes
            $table->index('is_active');
            $table->index(['type_name', 'is_active']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('booking_types');
    }
};
