<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commission_rates', function (Blueprint $table) {
            $table->id('commission_id');
            $table->string('commission_name', 255);
            $table->enum('commission_type', ['percentage', 'fixed']);
            $table->decimal('commission_value', 8, 2);
            $table->decimal('min_amount', 10, 2)->default(0);
            $table->decimal('max_amount', 10, 2)->nullable();
            $table->enum('applicable_to', [
                'all', 'nanny', 'home_worker', 'elderly_care',
                'pet_care', 'house_helper', 'special_needs_care'
            ])->default('all');
            $table->enum('booking_type', [
                'all', 'full_time', 'temporary', 'part_time'
            ])->default('all');
            $table->boolean('is_active')->default(true);
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->foreignId('created_by')->constrained('users', 'user_id');
            $table->timestamps();

            // Indexes
            $table->index(['is_active', 'effective_from', 'effective_to']);
            $table->index(['applicable_to', 'booking_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commission_rates');
    }
};
