<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('babysitter_profiles', function (Blueprint $table) {
            $table->id('profile_id');
            $table->foreignId('user_id')->constrained('users', 'user_id')->unique();
            $table->foreignId('occupation_category_id')->constrained('occupation_categories', 'category_id');
            $table->decimal('hourly_rate', 8, 2);
            $table->json('hourly_rates')->nullable();
            $table->integer('experience_years')->nullable();
            $table->enum('availability_type', ['full_time', 'part_time', 'occasional', 'flexible']);
            $table->boolean('immediate_availability')->default(false);
            $table->integer('service_range_km')->default(20);
            $table->boolean('willing_to_travel')->default(false);
            $table->boolean('has_vehicle')->default(false);
            $table->boolean('has_drivers_license')->default(false);
            $table->text('about_me')->nullable();
            $table->text('why_babysit')->nullable();
            $table->boolean('is_profile_public')->default(true);
            $table->boolean('is_verified')->default(false);
            $table->enum('verification_status', ['pending', 'verified', 'rejected'])->default('pending');
            $table->integer('total_reviews')->default(0);
            $table->decimal('average_rating', 3, 2)->default(0.00);
            $table->integer('completed_jobs')->default(0);
            $table->decimal('response_rate', 5, 2)->default(0.00);
            $table->integer('response_time_minutes')->default(0);
            $table->json('search_tags')->nullable();
            $table->timestamp('last_search_update')->nullable();
            $table->timestamps();

            // Indexes with shorter names
            $table->index(['is_profile_public', 'is_verified', 'availability_type'], 'bp_public_verified_avail_idx');
            $table->index(['hourly_rate'], 'bp_hourly_rate_idx');
            $table->index(['experience_years'], 'bp_experience_idx');
            $table->index(['average_rating'], 'bp_rating_idx');
            $table->index(['service_range_km'], 'bp_service_range_idx');
            $table->index(['created_at'], 'bp_created_at_idx');
            $table->index(['is_verified'], 'bp_verified_idx');
            $table->index(['availability_type'], 'bp_availability_idx');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('babysitter_profiles');
    }
};
