<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('occupation_categories', function (Blueprint $table) {
            $table->id('category_id');
            $table->string('category_name', 255);
            $table->text('category_description')->nullable();
            $table->enum('category_type', ['nanny', 'home_worker', 'elderly_care', 'pet_care', 'house_helper', 'special_needs_care']);
            $table->string('icon_url', 500)->nullable();
            $table->decimal('base_hourly_rate', 8, 2);
            $table->integer('min_experience_years')->default(0);
            $table->boolean('is_active')->default(true);
            $table->integer('sort_order')->default(0);
            $table->timestamps();

            $table->index(['category_type', 'is_active']);
            $table->index(['is_active']);
            $table->index(['sort_order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('occupation_categories');
    }
};
