<?php
// database/migrations/xxxx_xx_xx_xxxxxx_create_parent_profiles_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('parent_profiles', function (Blueprint $table) {
            $table->id('profile_id');
            $table->foreignId('user_id')->constrained('users', 'user_id')->unique();
            $table->text('family_description')->nullable();
            $table->text('household_rules')->nullable();
            $table->text('emergency_contacts')->nullable();
            $table->enum('preferred_communication', ['phone', 'email', 'in_app'])->default('in_app');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('parent_profiles');
    }
};
