<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('provinces', function (Blueprint $table) {
            $table->id('province_id');
            $table->foreignId('country_id')->constrained('countries', 'country_id');
            $table->string('province_code', 10);
            $table->string('province_name', 100);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique(['country_id', 'province_code']);
            $table->index(['is_active']);
            $table->index(['country_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('provinces');
    }
};
