<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Language extends Model
{
    use HasFactory;

    protected $primaryKey = 'language_id';

    protected $fillable = [
        'language_code',
        'language_name',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Get the user languages for this language.
     */
    public function userLanguages()
    {
        return $this->hasMany(UserLanguage::class, 'language_code', 'language_code');
    }
}
