<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    protected $primaryKey = 'country_id';

    protected $fillable = [
        'country_code',
        'country_name',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    /**
     * Get the provinces for the country.
     */
    public function provinces()
    {
        return $this->hasMany(Province::class, 'country_id', 'country_id');
    }

    /**
     * Scope active countries
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Find country by code
     */
    public static function findByCode($code)
    {
        return static::where('country_code', $code)->first();
    }
}
