<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CareRecipient extends Model
{
    use HasFactory;

    protected $primaryKey = 'recipient_id';

    protected $fillable = [
        'parent_id',
        'recipient_type',
        'name',
        'age',
        'gender',
        'health_mobility_details',
        'special_instructions',
        'allergies',
        'medications',
        'is_active'
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    public function parentProfile()
    {
        return $this->belongsTo(ParentProfile::class, 'parent_id', 'profile_id');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('recipient_type', $type);
    }

    public function scopeByParent($query, $parentId)
    {
        return $query->where('parent_id', $parentId);
    }
}
