<?php

namespace App\Events;

use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NewUserRegistered implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $user;
    public $userType;

    public function __construct(User $user, string $userType)
    {
        $this->user = $user;
        $this->userType = $userType;
    }

    public function broadcastOn(): array
    {
        return [
            new Channel('public-notifications'),
        ];
    }

    public function broadcastAs(): string
    {
        return 'user.registered';
    }

    public function broadcastWith(): array
    {
        return [
            'user_id' => $this->user->user_id,
            'user_name' => $this->user->first_name . ' ' . $this->user->last_name,
            'user_email' => $this->user->email,
            'user_type' => $this->userType,
            'message' => 'New ' . $this->userType . ' registered: ' . $this->user->first_name . ' ' . $this->user->last_name,
            'profile_picture' => $this->user->profile_picture_url,
            'registration_date' => $this->user->created_at->toDateTimeString(),
            'timestamp' => now()->toDateTimeString(),
            'icon' => '👤'
        ];
    }

    // ✅ YEH IMPORTANT METHOD ADD KARO
    public function broadcastVia()
    {
        return ['pusher'];
    }
}
