<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        \App\Console\Commands\CleanupExpiredBookingRequests::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        // Run cleanup every hour
        $schedule->command('booking-requests:cleanup')->hourly();

        // Process expired booking requests every hour
        $schedule->command('booking:process-expired')->hourly();

        // Process pending payments every 30 minutes
        $schedule->command('payments:process-pending')->everyThirtyMinutes();

        // Clean up old logs daily
        $schedule->command('log:clean')->daily();
    }

    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}
